/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.utility;

import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import java.math.BigInteger;
import java.util.Date;

public class OSCByteArrayToJavaConverter {
    byte[] bytes;
    int bytesLength;
    int streamPosition;

    public OSCPacket convert(byte[] byArray, int n) {
        this.bytes = byArray;
        this.bytesLength = n;
        this.streamPosition = 0;
        if (this.isBundle()) {
            return this.convertBundle();
        }
        return this.convertMessage();
    }

    private boolean isBundle() {
        String string = new String(this.bytes, 0, 7);
        return string.startsWith("#bundle");
    }

    private OSCBundle convertBundle() {
        this.streamPosition = 8;
        Date date = this.readTimeTag();
        OSCBundle oSCBundle = new OSCBundle(date);
        OSCByteArrayToJavaConverter oSCByteArrayToJavaConverter = new OSCByteArrayToJavaConverter();
        while (this.streamPosition < this.bytesLength) {
            int n = (Integer)this.readInteger();
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.bytes[this.streamPosition++];
            }
            OSCPacket oSCPacket = oSCByteArrayToJavaConverter.convert(byArray, n);
            oSCBundle.addPacket(oSCPacket);
        }
        return oSCBundle;
    }

    private OSCMessage convertMessage() {
        OSCMessage oSCMessage = new OSCMessage();
        oSCMessage.setAddress(this.readString());
        char[] cArray = this.readTypes();
        if (null == cArray) {
            return oSCMessage;
        }
        this.moveToFourByteBoundry();
        for (int i = 0; i < cArray.length; ++i) {
            if ('[' == cArray[i]) {
                oSCMessage.addArgument(this.readArray(cArray, ++i));
                while (']' != cArray[i]) {
                    ++i;
                }
                continue;
            }
            oSCMessage.addArgument(this.readArgument(cArray[i]));
        }
        return oSCMessage;
    }

    private String readString() {
        int n = this.lengthOfCurrentString();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.bytes[this.streamPosition++];
        }
        this.moveToFourByteBoundry();
        return new String(cArray);
    }

    private char[] readTypes() {
        if (this.bytes[this.streamPosition] != 44) {
            return null;
        }
        ++this.streamPosition;
        int n = this.lengthOfCurrentString();
        if (0 == n) {
            return null;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this.bytes[this.streamPosition++];
        }
        return cArray;
    }

    private Object readArgument(char c) {
        switch (c) {
            case 'i': {
                return this.readInteger();
            }
            case 'h': {
                return this.readBigInteger();
            }
            case 'f': {
                return this.readFloat();
            }
            case 'd': {
                return this.readDouble();
            }
            case 's': {
                return this.readString();
            }
            case 'c': {
                return this.readChar();
            }
            case 'T': {
                return Boolean.TRUE;
            }
            case 'F': {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private Object readChar() {
        return new Character((char)this.bytes[this.streamPosition++]);
    }

    private Object readDouble() {
        return this.readFloat();
    }

    private Object readFloat() {
        byte[] byArray = new byte[]{this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++]};
        BigInteger bigInteger = new BigInteger(byArray);
        return new Float(Float.intBitsToFloat(bigInteger.intValue()));
    }

    private Object readBigInteger() {
        byte[] byArray = new byte[]{this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++]};
        return new BigInteger(byArray);
    }

    private Object readInteger() {
        byte[] byArray = new byte[]{this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++], this.bytes[this.streamPosition++]};
        BigInteger bigInteger = new BigInteger(byArray);
        return new Integer(bigInteger.intValue());
    }

    private Date readTimeTag() {
        int n;
        int n2;
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[8];
        for (n2 = 0; n2 < 4; ++n2) {
            byArray[n2] = 0;
            byArray2[n2] = 0;
        }
        n2 = 1;
        for (n = 4; n < 8; ++n) {
            byArray[n] = this.bytes[this.streamPosition++];
            if (byArray[n] <= 0) continue;
            n2 = 0;
        }
        for (n = 4; n < 8; ++n) {
            byArray2[n] = this.bytes[this.streamPosition++];
            if (n < 7) {
                if (byArray2[n] <= 0) continue;
                n2 = 0;
                continue;
            }
            if (byArray2[n] <= 1) continue;
            n2 = 0;
        }
        if (n2 != 0) {
            return OSCBundle.TIMESTAMP_IMMEDIATE;
        }
        BigInteger bigInteger = new BigInteger(byArray);
        long l = bigInteger.longValue() - OSCBundle.SECONDS_FROM_1900_to_1970.longValue();
        if (l < 0L) {
            l = 0L;
        }
        long l2 = new BigInteger(byArray2).longValue();
        l2 = (l2 = l2 * 1000L / 0x100000000L) > 0L ? l2 + 1L : 0L;
        long l3 = l * 1000L + l2;
        return new Date(l3);
    }

    private Object[] readArray(char[] cArray, int n) {
        int n2 = 0;
        while (cArray[n + n2] != ']') {
            ++n2;
        }
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.readArgument(cArray[n + i]);
        }
        return objectArray;
    }

    private int lengthOfCurrentString() {
        int n = 0;
        while (this.bytes[this.streamPosition + n] != 0) {
            ++n;
        }
        return n;
    }

    private void moveToFourByteBoundry() {
        int n = this.streamPosition % 4;
        this.streamPosition += 4 - n;
    }
}

