
#ifndef MD_PAROLALIB_H
#define	MD_PAROLALIB_H

#define DEBUG_PAROLA		0
#define	DEBUG_PAROLA_FSM	0
#define	TIME_PROFILING		0

#if  DEBUG_PAROLA
#define	PRINT(s, v)		{ Serial.print(F(s)); Serial.print(v); }
#define	PRINTX(s, v)	{ Serial.print(F(s)); Serial.print(v, HEX); }
#define	PRINTS(s)		Serial.print(F(s))
#else
#define	PRINT(s, v)
#define	PRINTX(s, v)
#define	PRINTS(s)
#endif

#if  DEBUG_PAROLA_FSM
#define	FSMPRINT(s, v)	{ Serial.print(F(s)); Serial.print(v); }
#define	FSMPRINTX(s, v)	{ Serial.print(F(s)); Serial.print(v, HEX); }
#define	FSMPRINTS(s)	Serial.print(F(s))
#define	PRINT_STATE(f)	{ Serial.print(F("\n")); Serial.print(F(f)); Serial.print(F(" fsm ")); Serial.print(_fsmState); }
#else
#define	FSMPRINT(s, v)
#define	FSMPRINTX(s, v)
#define	FSMPRINTS(s)
#define	PRINT_STATE(f)
#endif

#if  TIME_PROFILING
#define	TIME_PROFILE(s)		{ Serial.print(F(s)); Serial.print(millis()-_lastRunTime); }
#else
#define	TIME_PROFILE(s)
#endif

// General macros and defines
#define	LIGHT_BAR	(_inverted ? 0 : 0xFF)	// all LEDs on
#define	EMPTY_BAR	(_inverted ? 0xFF : 0)	// all LEDS off
#define	DATA_BAR(d)	(_inverted ? ~d : d)	// specified data

#endif