#include <NmraDcc1.h>
// Working 17 Function DCC Decoder  DccAckPin not needed

// ******** UNLESS YOU WANT ALL CV'S RESET UPON EVERY POWER UP
// ******** AFTER THE INITIAL DECODER LOAD REMOVE THE "//" IN THE FOOLOWING LINE!!
//#define DECODER_LOADED
  
int tim_delay = 500;
#define numleds  17
byte ledpins [] = {3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19};
const int FunctionPin0 = 3;
const int FunctionPin1 = 4;
const int FunctionPin2 = 5;
const int FunctionPin3 = 6;
const int FunctionPin4 = 7;

const int FunctionPin5 = 8;
const int FunctionPin6 = 9;
const int FunctionPin7 = 10;
const int FunctionPin8 = 11;

const int FunctionPin9 = 12;
const int FunctionPin10 = 13;
const int FunctionPin11 = 14;     //A0
const int FunctionPin12 = 15;     //A1

const int FunctionPin13 = 16;     //A2
const int FunctionPin14 = 17;     //A3
const int FunctionPin15 = 18;     //A4
const int FunctionPin16 = 19;     //A5
NmraDcc  Dcc ;
DCC_MSG  Packet ;

#define This_Decoder_Address 24

struct CVPair
{
  uint16_t  CV;
  uint8_t   Value;
};
CVPair FactoryDefaultCVs [] =
{
  {CV_MULTIFUNCTION_PRIMARY_ADDRESS, This_Decoder_Address},
  {CV_ACCESSORY_DECODER_ADDRESS_MSB, 0},
  {CV_MULTIFUNCTION_EXTENDED_ADDRESS_MSB, 0},
  {CV_MULTIFUNCTION_EXTENDED_ADDRESS_LSB, 0},
};

uint8_t FactoryDefaultCVIndex = 0;
void notifyCVResetFactoryDefault()
{
  // Make FactoryDefaultCVIndex non-zero and equal to num CV's to be reset 
  // to flag to the loop() function that a reset to Factory Defaults needs to be done
  FactoryDefaultCVIndex = sizeof(FactoryDefaultCVs)/sizeof(CVPair);
};

void setup()
{
   //Serial.begin(115200);
   // initialize the digital pins as an outputs
    for (int i=0; i< numleds; i++) {
      pinMode(ledpins[i], OUTPUT);
      digitalWrite(ledpins[i], LOW);
     }
  for (int i=0; i< numleds; i++) {
     digitalWrite(ledpins[i], HIGH);
     delay (tim_delay/10);
  }
  delay( tim_delay);
  for (int i=0; i< numleds; i++) {
     digitalWrite(ledpins[i], LOW);
     delay (tim_delay/10);
  }
  delay( tim_delay);
    
  #if defined(DECODER_LOADED)
  if ( Dcc.getCV(CV_DECODER_MASTER_RESET)== CV_DECODER_MASTER_RESET ) 
  #endif  
     {
       for (int j=0; j < FactoryDefaultCVIndex; j++ )
         Dcc.setCV( FactoryDefaultCVs[j].CV, FactoryDefaultCVs[j].Value);
         digitalWrite(ledpins[14], 1);
         delay (1000);
         digitalWrite(ledpins[14], 0);
     }  
  // Setup which External Interrupt, the Pin it's associated with that we're using and enable the Pull-Up 
  Dcc.pin(0, 2, 0);
  // Call the main DCC Init function to enable the DCC Receiver
  Dcc.init( MAN_ID_DIY, 100, FLAGS_MY_ADDRESS_ONLY, 0 );
}
void loop()
{
  // You MUST call the NmraDcc.process() method frequently from the Arduino loop() function for correct library operation
  Dcc.process();

}
extern void notifyDccFunc( uint16_t Addr, uint8_t FuncNum, uint8_t FuncState)  {
  if (FuncNum==1) {  //Function Group 1 F0 F4 F3 F2 F1
	  digitalWrite( FunctionPin0, (FuncState&0x10)>>4 );
	  digitalWrite( FunctionPin1, (FuncState&0x01 ));
	  digitalWrite( FunctionPin2, (FuncState&0x02)>>1 );
	  digitalWrite( FunctionPin3, (FuncState&0x04)>>2 );
	  digitalWrite( FunctionPin4, (FuncState&0x08)>>3 );
  }
  else if (FuncNum==2) {  //Function Group 1 S FFFF == 1 F8 F7 F6 F5  &  == 0  F12 F11 F10 F9 F8
    if ((FuncState & 0x10)==0x10)  {
	  digitalWrite( FunctionPin5, (FuncState&0x01 ));
	  digitalWrite( FunctionPin6, (FuncState&0x02)>>1 );
	  digitalWrite( FunctionPin7, (FuncState&0x04)>>2 );
	  digitalWrite( FunctionPin8, (FuncState&0x08)>>3 );
	  }
	  else {
	    digitalWrite( FunctionPin9, (FuncState&0x01 ));
	    digitalWrite( FunctionPin10, (FuncState&0x02)>>1 );
	    digitalWrite( FunctionPin11, (FuncState&0x04)>>2 );
	    digitalWrite( FunctionPin12, (FuncState&0x08)>>3 );
	  }
  }
  else if (FuncNum==3) {  //Function Group 2 FuncState == F20-F13 Function Control
    digitalWrite( FunctionPin13, (FuncState&0x01 ));
	digitalWrite( FunctionPin14, (FuncState&0x02)>>1 );
	digitalWrite( FunctionPin15, (FuncState&0x04)>>2 );
	digitalWrite( FunctionPin16, (FuncState&0x08)>>3 );
  }
}

