// working d. bodnar 11-30-2016 with mosfet
// used a 7805 to drop 12 to 5 and fed that to the VCC input
//  1K resistor from pin 4 to base of mosfet
//  works well!
// FIXED with folder delete explained here   https://github.com/esp8266/Arduino/issues/1387 

#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <WiFiUdp.h>
#include <functional>
#include "switch.h"
#include "UpnpBroadcastResponder.h"
#include "CallbackFunction.h"
int LED4 = 4;
int LED5 = 5;
int LEDRed = 15; // built in LEDs
int LEDGreen = 12;
int LEDBlue = 13;
// prototypes
boolean connectWifi();

//on/off callbacks
void stereoOn();
void stereoOff();
//void kitchenLightsOn();
//void kitchenLightsOff();

// Change this before you flash
const char* ssid = "main2";
const char* password = "Chumley8";

boolean wifiConnected = false;

UpnpBroadcastResponder upnpBroadcastResponder;

Switch *stereo = NULL;
//Switch *kitchen = NULL;

void setup()
{
  pinMode(LED5, OUTPUT);
  pinMode(LED4, OUTPUT);
  pinMode(LEDRed, OUTPUT);
  pinMode(LEDGreen, OUTPUT);
  pinMode(LEDBlue, OUTPUT);
  Serial.begin(9600);

  // Initialise wifi connection
  wifiConnected = connectWifi();

  if (wifiConnected) {
    digitalWrite(LEDGreen, HIGH);
    upnpBroadcastResponder.beginUdpMulticast();

    // Define your switches here. Max 14
    // Format: Alexa invocation name, local port no, on callback, off callback
    stereo = new Switch("stereo ", 80, stereoOn, stereoOff);
    // kitchen = new Switch("kitchen lights", 81, kitchenLightsOn, kitchenLightsOff);

    Serial.println("Adding switches upnp broadcast responder");
    upnpBroadcastResponder.addDevice(*stereo);
    //  upnpBroadcastResponder.addDevice(*kitchen);
  }

  //  digitalWrite(LEDRed, HIGH);
  // digitalWrite(LEDGreen, HIGH);
  //  digitalWrite(LEDBlue, HIGH);
  delay(2000);
  //  digitalWrite(LEDRed, LOW);
  digitalWrite(LEDGreen, LOW);

  //  digitalWrite(LEDBlue, LOW);

}

void loop()
{
  if (wifiConnected) {
    //  digitalWrite(LEDGreen, HIGH);
    upnpBroadcastResponder.serverLoop();

    //    kitchen->serverLoop();
    stereo->serverLoop();
  }
  else {
    //  digitalWrite(LEDGreen, LOW);
  }
}

void stereoOn() {
  Serial.print("Switch 1 turn on ...");
  digitalWrite(LED4, HIGH);
  digitalWrite(LEDBlue, LOW);
  digitalWrite(LEDRed, LOW);
  digitalWrite(LEDGreen, HIGH);
  // digitalWrite(LEDBlue, HIGH);
}

void stereoOff() {
  Serial.print("Switch 1 turn off ...");
  digitalWrite(LED4, LOW);
  //digitalWrite(LEDBlue, LOW);
  digitalWrite(LEDRed, HIGH);
  digitalWrite(LEDGreen, LOW);

  //  digitalWrite(LEDBlue, LOW);
}

void kitchenLightsOn() {
  Serial.print("Switch 2 turn on ...");
  digitalWrite(LED5, HIGH);
}

void kitchenLightsOff() {
  Serial.print("Switch 2 turn off ...");
  digitalWrite(LED5, LOW);
}

// connect to wifi – returns true if successful or false if not
boolean connectWifi() {
  boolean state = true;
  int i = 0;

  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid, password);
  Serial.println("");
  Serial.println("Connecting to WiFi");

  // Wait for connection
  Serial.print("Connecting ...");
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
    if (i > 10) {
      state = false;
      break;
    }
    i++;
  }

  if (state) {
    Serial.println("");
    Serial.print("Connected to ");
    Serial.println(ssid);
    Serial.print("IP address: ");
    Serial.println(WiFi.localIP());
  }
  else {
    Serial.println("");
    Serial.println("Connection failed.");
  }

  return state;
}
